/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 20.3)
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 *
 *  (S tu dwie kompletne wersje: pierwsza samodzielnie analizuje 
 *  zawarto argv, druga wywouje getopt.)
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>


#ifdef mac
#include <console.h>
#endif

#define GETOPT

#ifndef GETOPT

main(int argc, char *argv[])
{
	int argi;
	int aflag = 0;
	char *bval = NULL;
#ifdef mac
	argc = ccommand(&argv);
#endif

	for(argi = 1; argi < argc && argv[argi][0] == '-'; argi++) {
		char *p;
		for(p = &argv[argi][1]; *p != '\0'; p++) {
			switch(*p) {
			case 'a':
				aflag = 1;
				printf("podano opcj -a\n");
				break;

			case 'b':
				bval = argv[++argi];
				printf("podano opcj -b z argumentem \"%s\"\n", bval);
				break;

			default:
				fprintf(stderr,
					"nieznana opcja -%c\n", *p);
			}
		}
	}

	if(argi >= argc) {
		/* nie podano nazw plikw, czytamy z stdin */
		printf("czytanie ze standardowego wejcia\n");
	} else {
		/* przetwarzamy nazwy plikw */

		for(; argi < argc; argi++) {
			FILE *ifp = fopen(argv[argi], "r");
			if(ifp == NULL) {
				fprintf(stderr, "nie mona otworzy %s: %s\n",
					argv[argi], strerror(errno));
				continue;
			}

			printf("przetwarzanie pliku %s\n", argv[argi]);

			fclose(ifp);
		}
	}

	return 0;
}

#else

#ifdef __STDC__
extern int getopt(int, char * const *, const char *);
#endif

extern char *optarg;
extern int optind;

main(int argc, char *argv[])
{
	int aflag = 0;
	char *bval = NULL;
	int c;
#ifdef mac
	argc = ccommand(&argv);
#endif

	while((c = getopt(argc, argv, "ab:")) != -1)
		switch(c) {
		case 'a':
			aflag = 1;
			printf("podano opcj -a\n");
			break;

		case 'b':
			bval = optarg;
			printf("podano opcj -b z argumentem \"%s\"\n", bval);
			break;
	}

	if(optind >= argc) {
		/* nie podano nazw plikw, czytamy z stdin */
		printf("czytanie ze standardowego wejcia\n");
	} else {
		/* przetwarzamy nazwy plikw */

		for(; optind < argc; optind++) {
			FILE *ifp = fopen(argv[optind], "r");
			if(ifp == NULL) {
				fprintf(stderr, "nie mona otworzy %s: %s\n",
					argv[optind], strerror(errno));
				continue;
			}

			printf("przetwarzanie pliku %s\n", argv[optind]);

			fclose(ifp);
		}
	}

	return 0;
}

#endif
